CREATE DATABASE Mikroprodaja;
GO
USE Mikroprodaja;
GO

CREATE TABLE Proizvod
(	IDProizvoda	int				PRIMARY KEY IDENTITY(1,1),
	Naziv		nvarchar(max)	NOT NULL,
	Cijena		money			NOT NULL
);
CREATE TABLE ProdajnoMjesto
(	IDProdajnogMjesta	int				PRIMARY KEY IDENTITY(1,1),
	Naziv				nvarchar(max)	NOT NULL,
	Adresa				nvarchar(max)	NULL
);

CREATE TABLE ZalihaProizvoda
(	IDZalihaProizvoda	int				PRIMARY KEY IDENTITY(1,1),
	ProdajnoMjestoID	int				NOT NULL
		CONSTRAINT	FK_ProdajnoMjesto_ZalihaProizvoda
			FOREIGN KEY (ProdajnoMjestoID)	REFERENCES ProdajnoMjesto(IDProdajnogMjesta),
	ProizvodID			int				NOT NULL
		CONSTRAINT	FK_Proizvod_ZalihaProizvoda
			FOREIGN KEY (ProizvodID)	REFERENCES Proizvod(IDProizvoda),
	Stanje				int				NOT NULL	DEFAULT 0,
	CONSTRAINT UK_ZalihaProizvoda
		UNIQUE(ProdajnoMjestoID, ProizvodID)
);

CREATE TABLE VrstaZaposlenika
(	IDVrstaZaposlenika	int				PRIMARY KEY IDENTITY(1,1),
	Naziv				nvarchar(max)	NOT NULL
);

CREATE TABLE Zaposlenik
(	OIB					char(13)				PRIMARY KEY,
	Ime					nvarchar(max)	NOT NULL,
	Prezime				nvarchar(max)	NOT NULL,
	NadredjeniOIB		char(13)				NULL
		CONSTRAINT	FK_Nadredjeni
			FOREIGN KEY (NadredjeniOIB)	REFERENCES Zaposlenik(OIB),
	ProdajnoMjestoID	int				NOT NULL
		CONSTRAINT	FK_ProdajnoMjesto
			FOREIGN KEY (ProdajnoMjestoID)	REFERENCES ProdajnoMjesto(IDProdajnogMjesta),
	VrstaZaposlenikaID	int				NOT NULL
		CONSTRAINT	FK_VrstaZaposlenika
			FOREIGN KEY (VrstaZaposlenikaID)	REFERENCES VrstaZaposlenika(IDVrstaZaposlenika)
);

SET IDENTITY_INSERT Proizvod ON;
INSERT INTO Proizvod(IDProizvoda, Naziv, Cijena) VALUES (1,'Fiat Tipo',20000);
INSERT INTO Proizvod(IDProizvoda, Naziv, Cijena) VALUES (2,'Dell laptop',2000);
INSERT INTO Proizvod(IDProizvoda, Naziv, Cijena) VALUES (3,'Golf IV',15000);
SET IDENTITY_INSERT Proizvod OFF;

SET IDENTITY_INSERT ProdajnoMjesto ON;
INSERT INTO ProdajnoMjesto(IDProdajnogMjesta, Naziv, Adresa) VALUES (1,'Prvi duan','Anieva 12, Zagreb');
INSERT INTO ProdajnoMjesto(IDProdajnogMjesta, Naziv, Adresa) VALUES (2,'Drugi duan','Perieva 44, Split');
INSERT INTO ProdajnoMjesto(IDProdajnogMjesta, Naziv, Adresa) VALUES (3,'Trei duan','Vesnina 10, Zadar');
SET IDENTITY_INSERT ProdajnoMjesto OFF;


INSERT INTO ZalihaProizvoda(ProdajnoMjestoID, ProizvodID, Stanje) VALUES (1,1,20);
INSERT INTO ZalihaProizvoda(ProdajnoMjestoID, ProizvodID, Stanje) VALUES (1,2,30);
INSERT INTO ZalihaProizvoda(ProdajnoMjestoID, ProizvodID, Stanje) VALUES (1,3,40);
INSERT INTO ZalihaProizvoda(ProdajnoMjestoID, ProizvodID, Stanje) VALUES (2,1,5);
INSERT INTO ZalihaProizvoda(ProdajnoMjestoID, ProizvodID, Stanje) VALUES (2,2,35);
INSERT INTO ZalihaProizvoda(ProdajnoMjestoID, ProizvodID, Stanje) VALUES (3,1,15);
INSERT INTO ZalihaProizvoda(ProdajnoMjestoID, ProizvodID, Stanje) VALUES (3,3,7);


SET IDENTITY_INSERT VrstaZaposlenika ON;
INSERT INTO VrstaZaposlenika(IDVrstaZaposlenika, Naziv) VALUES (1,'Voditelj');
INSERT INTO VrstaZaposlenika(IDVrstaZaposlenika, Naziv) VALUES (2,'Zaposlenik');
SET IDENTITY_INSERT VrstaZaposlenika OFF;

INSERT INTO
	Zaposlenik(OIB, Ime, Prezime, NadredjeniOIB, ProdajnoMjestoID, VrstaZaposlenikaID)
VALUES
	('8332451267827', 'Ana', 'Ani', NULL, 1, 1);
INSERT INTO
	Zaposlenik(OIB, Ime, Prezime, NadredjeniOIB, ProdajnoMjestoID, VrstaZaposlenikaID)
VALUES
	('6529806541277', 'Mara', 'Mari', NULL, 2, 1);
INSERT INTO
	Zaposlenik(OIB, Ime, Prezime, NadredjeniOIB, ProdajnoMjestoID, VrstaZaposlenikaID)
VALUES
	('4453451239855', 'Petra', 'Petri', NULL, 3, 1);

INSERT INTO
	Zaposlenik(OIB, Ime, Prezime, NadredjeniOIB, ProdajnoMjestoID, VrstaZaposlenikaID)
VALUES
	('1267891144223', 'Petar', 'Peri', '8332451267827', 1, 2);
INSERT INTO
	Zaposlenik(OIB, Ime, Prezime, NadredjeniOIB, ProdajnoMjestoID, VrstaZaposlenikaID)
VALUES
	('8812456723467', 'Hrvoje', 'Horvat', '8332451267827', 1, 2);

INSERT INTO
	Zaposlenik(OIB, Ime, Prezime, NadredjeniOIB, ProdajnoMjestoID, VrstaZaposlenikaID)
VALUES
	('3312567891133', 'Marko', 'Mari', '6529806541277', 2, 2);
INSERT INTO
	Zaposlenik(OIB, Ime, Prezime, NadredjeniOIB, ProdajnoMjestoID, VrstaZaposlenikaID)
VALUES
	('5566128843732', 'Damir', 'Damirovi', '6529806541277', 2, 2);

INSERT INTO
	Zaposlenik(OIB, Ime, Prezime, NadredjeniOIB, ProdajnoMjestoID, VrstaZaposlenikaID)
VALUES
	('8889991242213', 'Darko', 'Darkovi', '4453451239855', 3, 2);
INSERT INTO
	Zaposlenik(OIB, Ime, Prezime, NadredjeniOIB, ProdajnoMjestoID, VrstaZaposlenikaID)
VALUES
	('7744333222564', 'Denis', 'Denisi', '4453451239855', 3, 2);



